<?php

function css_child_enqueue_styles() {
    $rand = rand( 1, 99999999999 );
    wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', '', $rand );
}
add_action( 'wp_enqueue_scripts', 'css_child_enqueue_styles' );

add_theme_support ( 'genesis-menus' , array ( 'primary' => __( 'Header Navigation Menu', 'altitude' ), 'secondary' => __( 'Above Header Navigation Menu', 'altitude' ), 'footer' => __( 'Footer Navigation Menu', 'altitude' ) ) );

// Custom Kolomedia.eu
add_action( 'wp_enqueue_scripts', 'yith_wcwl_custom_enqueue_fontawesome', 15 );
function remove_footer_admin () {
  echo 'Izdelava spletne strani <a href="https://www.kolomedia.eu">Kolomedia.eu</a>';
}
add_filter('admin_footer_text', 'remove_footer_admin');


function custom_field_display_below_title(){
    global $product;

    // Get the custom field value
    $custom_field = get_post_meta( $product->get_id(), 'nr_of_items', true );

    // Display
    if( ! empty($custom_field) ){
        echo '<p class="my-custom-field">'.$custom_field.'</p>';
    }
}
add_action( 'woocommerce_before_shop_loop_item_title', 'custom_field_display_below_title', 2 );


// povpraševanje po izdelku
function merrell_more_info_contact_form_box() {
?>
<script type="text/javascript">
jQuery('.moveon-custom-product-button-inquiry').on('click', function(){
    
    jQuery('input[name="text-440"]').val('<?php the_title(); ?>');

});
</script>
<?php
}
//add_action( 'woocommerce_single_product_summary', 'merrell_more_info_contact_form_box', 40 );
add_action( 'wp_footer', 'merrell_more_info_contact_form_box', 40 );

//desable comments
add_action('admin_init', function () {
    // Redirect any user trying to access comments page
    global $pagenow;
    
    if ($pagenow === 'edit-comments.php') {
        wp_redirect(admin_url());
        exit;
    }

    // Remove comments metabox from dashboard
    remove_meta_box('dashboard_recent_comments', 'dashboard', 'normal');

    // Disable support for comments and trackbacks in post types
    foreach (get_post_types() as $post_type) {
        if (post_type_supports($post_type, 'comments')) {
            remove_post_type_support($post_type, 'comments');
            remove_post_type_support($post_type, 'trackbacks');
        }
    }
});

// Close comments on the front-end
add_filter('comments_open', '__return_false', 20, 2);
add_filter('pings_open', '__return_false', 20, 2);

// Hide existing comments
add_filter('comments_array', '__return_empty_array', 10, 2);

// Remove comments page in menu
add_action('admin_menu', function () {
    remove_menu_page('edit-comments.php');
});

// Remove comments links from admin bar
add_action('init', function () {
    if (is_admin_bar_showing()) {
        remove_action('admin_bar_menu', 'wp_admin_bar_comments_menu', 60);
    }
});

// PRDUCTS VIEW MORE
add_filter( 'woocommerce_product_add_to_cart_text', function( $text ) {
    global $product;
    if ( $product->is_type( 'variable' ) ) {
        $text = $product->is_purchasable() ? __( 'More Options', 'woocommerce' ) : __( 'Read more', 'woocommerce' );
    }
    return $text;
}, 10 );

/**
 * remove add to cart buttons on shop archive page
 */

add_filter( 'woocommerce_loop_add_to_cart_link', 'replacing_add_to_cart_button', 10, 2 );
function replacing_add_to_cart_button( $button, $product  ) {
    if ( $product->is_type( 'simple' ) ) {
        $button_text = __("View product", "woocommerce");
        $button = '<a class="custom-button-woo" href="' . $product->get_permalink() . '">' .
        $button_text . '</a>';
    }
    return $button;
}
//vat
add_filter( 'woocommerce_get_price_html', 'custom_price_message' );
function custom_price_message( $price ) {
    $vat = ' (VAT 22% incl)';
    return $price . $vat;
}